<?php

/* @package Joomla

 * @copyright Copyright (C) Open Source Matters. All rights reserved.

 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php

 * @extension Phoca Extension

 * @copyright Copyright (C) Jan Pavelka www.phoca.cz

 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL

 */



defined( '_JEXEC' ) or die( 'Restricted access' );



jimport( 'joomla.plugin.plugin' );



class plgSearchPhocaCategories extends JPlugin

{





	public function __construct(& $subject, $config) {

    parent::__construct($subject, $config);

	}



	function onContentSearchAreas() {

		static $areas = array(

			'phocaproduct' => 'PLG_SEARCH_PHOCACATEGORIES'

			);

			return $areas;

	}



	function onContentSearch( $text, $phrase = '', $ordering = '', $areas = null ) {



		$db		= JFactory::getDbo();

		$app	= JFactory::getApplication();

		$user	= JFactory::getUser();



		$groups	= implode(',', $user->getAuthorisedViewLevels());



		$limit = $this->params->get('search_limit', 20);



		$text = trim( $text );

		if ($text == '') {

			return array();

		}



	  $catType = $this->params->get('categorytype', 1);

      

      $categoryExc = "";



      if ($this->params->get('excludecats')) {

        $categoryExc = " AND c.id ". ($catType ? "IN" : "NOT IN" ) ." (".implode(",", $this->params->get('excludecats')).") ";        

      }



		$wheres		= array();

		$wheres3	= array();

		switch ($phrase)

		{

			case 'exact':

				$text		= $db->quote('%'.$db->escape($text, true).'%', false);

				$wheres2	= array();

				$wheres2[]	= 'c.title LIKE '.$text;

				$wheres2[]	= 'c.alias LIKE '.$text;

				$wheres2[]	= 'c.metakey LIKE '.$text;

				$wheres2[]	= 'c.metadesc LIKE '.$text;

				$wheres2[]	= 'c.description LIKE '.$text;

        

				$wheres3[]	= '(' . implode(') OR (', $wheres2) . ')';

				break;



			case 'all':

			case 'any':

			default:

				$words	= explode(' ', $text);

				$wheres = array();

				foreach ($words as $word)

				{

					$word		= $db->quote('%'.$db->escape($word, true).'%', false);

					$wheres2	= array();

					$wheres2[]	= 'c.title LIKE '.$word;

					$wheres2[]	= 'c.alias LIKE '.$word;

					$wheres2[]	= 'c.metakey LIKE '.$word;

					$wheres2[]	= 'c.metadesc LIKE '.$word;

					$wheres2[]	= 'c.description LIKE '.$word;

          

					$wheres[]	= implode(' OR ', $wheres2);

				}

				$wheres3[]	= '(' . implode(($phrase == 'all' ? ') AND (' : ') OR ('), $wheres) . ')';

				break;

		}



		$where = implode(' AND ', $wheres3);



		if ( $limit > 0 ) {

    

			$query = "SELECT DISTINCT c.id, c.title AS title, c.description AS text, c.alias, c.created AS created, c.image as image, c.alias as catalias " .

			" FROM #__phocacart_categories AS c" .

			" WHERE $where AND c.published = 1 " .$categoryExc .

			" GROUP BY c.id";

      

			$db->setQuery( $query, 0, $limit );

			$products = $db->loadObjectList();

      

			if(isset($products)) {

				  foreach($products as $key => $value) { 

					  $products[$key]->href = JRoute::_(PhocacartRoute::getCategoryRoute($value->id, $value->alias));

            $products[$key]->image = JURI::root().'images/phocacartcategories/'.$value->image;

					}

			}

		}



		$rows[] = $products;

    $results = array();



		if(count($rows)) {

			foreach($rows as $row) {

				$results = array_merge($results, (array) $row);

			}

		}



		return $results;

    }	

	}

