<?php

/* @package Joomla

 * @copyright Copyright (C) Open Source Matters. All rights reserved.

 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php

 * @extension Phoca Extension

 * @copyright Copyright (C) Jan Pavelka www.phoca.cz

 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL

 */



defined( '_JEXEC' ) or die( 'Restricted access' );



jimport( 'joomla.plugin.plugin' );



class plgSearchPhocaProduct extends JPlugin

{





	public function __construct(& $subject, $config) {

		parent::__construct($subject, $config);

	}



	function onContentSearchAreas() {

		static $areas = array(

			'phocaproduct' => 'PLG_SEARCH_PHOCAPRODUCT'

			);

			return $areas;

	}



	function onContentSearch( $text, $phrase = '', $ordering = '', $areas = null ) {



		$db		= JFactory::getDbo();

		$app	= JFactory::getApplication();

		$user	= JFactory::getUser();

		$groups	= implode(',', $user->getAuthorisedViewLevels());



		$limit = $this->params->get('search_limit', 20);



		$text = trim( $text );

		if ($text == '') {

			return array();

		}



		$catType = $this->params->get('categorytype', 1);

      

      $categoryExc = "";



      if ($this->params->get('excludecats')) {

        $categoryExc = " AND pc.category_id ". ($catType ? "IN" : "NOT IN" ) ." (".implode(",", $this->params->get('excludecats')).") ";        

      }



		$wheres		= array();

		$wheres3	= array();

		switch ($phrase)

		{

			case 'exact':

				$text		= $db->quote('%'.$db->escape($text, true).'%', false);

				$wheres2	= array();

				$wheres2[]	= 'p.title LIKE '.$text;

				$wheres2[]	= 'p.alias LIKE '.$text;

				$wheres2[]	= 'p.metakey LIKE '.$text;

				$wheres2[]	= 'p.metadesc LIKE '.$text;

				$wheres2[]	= 'p.description LIKE '.$text;

        $wheres2[]	= 't.title LIKE '.$text;

        

				$wheres3[]	= '(' . implode(') OR (', $wheres2) . ')';

				break;



			case 'all':

			case 'any':

			default:

				$words	= explode(' ', $text);

				$wheres = array();

				foreach ($words as $word)

				{

					$word		= $db->quote('%'.$db->escape($word, true).'%', false);

					$wheres2	= array();

					$wheres2[]	= 'p.title LIKE '.$word;

					$wheres2[]	= 'p.alias LIKE '.$word;

					$wheres2[]	= 'p.metakey LIKE '.$word;

					$wheres2[]	= 'p.metadesc LIKE '.$word;

					$wheres2[]	= 'p.description LIKE '.$word;

          $wheres2[]	= 't.title LIKE '.$word;

          

					$wheres[]	= implode(' OR ', $wheres2);

				}

				$wheres3[]	= '(' . implode(($phrase == 'all' ? ') AND (' : ') OR ('), $wheres) . ')';

				break;

		}

    

		$where = implode(' AND ', $wheres3);



		if ( $limit > 0 ) {

    

			$query = "SELECT DISTINCT p.id, p.title AS title, c.id as catid, p.description AS text, p.alias, p.created AS created, p.image as image, c.alias as catalias" .

			" FROM #__phocacart_products AS p" .

			 " LEFT JOIN #__phocacart_product_categories AS pc on pc.product_id = p.id " .

      " LEFT JOIN #__phocacart_categories AS c on c.id = pc.category_id " .

      " LEFT JOIN #__phocacart_tags_related AS tr on tr.item_id = p.id " .

      " LEFT JOIN #__phocacart_tags AS t on t.id = tr.tag_id " .

			" WHERE $where AND p.published = 1" . $categoryExc .

			" GROUP BY p.id";

      

			$db->setQuery( $query, 0, $limit );

			$products = $db->loadObjectList();

           

			if(isset($products)) {

				foreach($products as $key => $value) { 

							$products[$key]->href =  JRoute::_(PhocacartRoute::getItemRoute($value->id, $value->catid, $value->alias, $value->catalias)); 

              $products[$key]->image = JURI::root().'images/phocacartproducts/'.$value->image;

					}

				}

			}



			$rows[] = $products;

      $results = array();

      

  		if(count($rows)) {

  			foreach($rows as $row) {

  				$results = array_merge($results, (array) $row);

  			}

  		}

  

  		return $results;

    }	

	}

