<?php
/*------------------------------------------------------------------------
# com_offlajn_installer - Offlajn Installer
# ------------------------------------------------------------------------
# author    Balint Polgarfi
# copyright Copyright (C) 2012 Offlajn.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.offlajn.com
-------------------------------------------------------------------------*/
?>
<?php
defined('_JEXEC') or die('Restricted access');
jimport('joomla.installer.helper');
jimport('joomla.filesystem.folder');
defined('DS') or define( 'DS', DIRECTORY_SEPARATOR );
if(!function_exists('deleteExtFolder')){

  function deleteExtFolder() {
    $pkg_path = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_offlajn_installer'.DS.'extensions';
    if (file_exists($pkg_path)) JFolder::delete($pkg_path);
    if (!version_compare(JVERSION,'1.6.0','lt')) {
      $db = JFactory::getDBO();
      $db->setQuery("DELETE FROM #__menu WHERE title='com_offlajn_installer'");
      $db->query();
    }
  }

  function com_install(){
    register_shutdown_function("deleteExtFolder");
  	$installer = new Installer();
  	$installer->install();
  	return true;
  }

  function com_uninstall(){
  	$installer = new Installer();
  	$installer->uninstall();
  	return true;
  }

  class Installer extends JObject {

  	var $name = 'Offlajn Installer';
    var $com = 'com_offlajn_installer';

    function copyr($source, $dest) {
        // Check for symlinks
        if (is_link($source)) {
            return symlink(readlink($source), $dest);
        }
        
        // Simple copy for a file
        if (is_file($source)) {
            return copy($source, $dest);
        }
    
        // Make destination directory
        if (!is_dir($dest)) {
            mkdir($dest);
        }
    
        // Loop through the folder
        $dir = dir($source);
        while (false !== $entry = $dir->read()) {
            // Skip pointers
            if ($entry == '.' || $entry == '..') {
                continue;
            }
    
            // Deep copy directories
            $this->copyr("$source/$entry", "$dest/$entry");
        }
    
        // Clean up
        $dir->close();
        return true;
    }  	
    
    function install() {
      $pkg_path = JPATH_ADMINISTRATOR.DS.'components'.DS.$this->com.DS.'extensions'.DS;

			$suc = glob($pkg_path . '*/installmsg/successful.html');
			$suc = isset($suc[0]) ? file_get_contents($suc[0]) : '';
			$unsuc = glob(dirname(__FILE__) . '/admin/extensions/*/installmsg/unsuccessful.html');
			$unsuc = isset($unsuc[0]) ? file_get_contents($unsuc[0]) : '';

      $extensions = array_merge(JFolder::folders($pkg_path,'^(?!com_)\w+$'),JFolder::folders($pkg_path,'^com_\w+$'));
      $v3 = version_compare(JVERSION,'3.0.0','ge');
      if ($v3) {
        foreach($extensions as $pkg) {
          $f = $pkg_path.DS.$pkg;
          $xmlfiles = JFolder::files($f, '.xml$', 1, true);
          foreach($xmlfiles AS $xmlf){
            $file = file_get_contents($xmlf);
            file_put_contents($xmlf, preg_replace("/<\/install/","</extension",preg_replace("/<install/","<extension",$file)));
          }
        }
      }
			$error = array();
			ob_start();
        if(!is_dir(JPATH_SITE.DS.'components'.DS.'com_layer_slider')) {
          JFactory::getApplication()->enqueueMessage('<br />Error! Layer Slider component is not installed!', 'error');
        } else {
          $inst = new Installer();
          $inst->copyr(dirname(__FILE__) . '/skins', JPATH_SITE.DS.'components'.DS.'com_layer_slider'.DS.'base'.DS.'static'.DS.'skins');
          JFactory::getApplication()->enqueueMessage('<br />Skins successfully installed!');
        }

			$table = ob_get_contents();
			ob_end_clean();

			if (count($error)) {
				if ($unsuc) {
					echo $unsuc;
					foreach ($error as $e) { echo $e.'<br/>'; }
					echo '</div>';
				} else echo $table;
			} else echo $suc ? $suc : $table;


  	}

  	function uninstall() {
    }

  }

  class com_offlajn_installerInstallerScript
  {
    function install($parent) {
  		com_install();
  	}

    function uninstall($parent) {
  		com_uninstall();
  	}

  	function update($parent) {
  		com_install();
  	}
  }
}