<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  Search.easysocial
 *
 * @copyright   Copyright (C) Offlajn.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * EasySocial Search plugin
 *
 * @package     Joomla.Plugin
 * @subpackage  Search.easysocial
 * @since       1.6
 */
class PlgSearchEasysocial extends JPlugin
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 * @since  3.1
	 */
	protected $autoloadLanguage = true;

	/**
	 * @return array An array of search areas
	 */
	public function onContentSearchAreas()
	{
		static $areas = array(
			'easysocial' => 'PLG_SEARCH_EASYSOCIAL_EASYSOCIAL'
		);
		return $areas;
	}


	public function onContentSearch($text, $phrase = '', $ordering = '', $areas = null)
	{
		$db = JFactory::getDbo();
		$app = JFactory::getApplication();
		$user = JFactory::getUser();

		if (is_array($areas))
		{
			if (!array_intersect($areas, array_keys($this->onContentSearchAreas())))
			{
				return array();
			}
		}

		$albums = $this->params->get('search_albums', 1);
    $groups = $this->params->get('search_groups', 1);
    $photos = $this->params->get('search_photos', 1);
    $users = $this->params->get('search_users', 1);
    
		
		$limit = $this->params->def('search_limit', 50);
		$state = array();
		

		$text = trim($text);
		if ($text == '')
		{
			return array();
		}

		$section = JText::_('Easysocial');

		switch ($ordering)
		{
			case 'alpha':
				$order = 'a.name ASC';
				break;

			case 'category':
				$order = 'c.title ASC, a.name ASC';
				break;

			case 'popular':
			case 'newest':
			case 'oldest':
			default:
				$order = 'a.name DESC';
		}

		$text = $db->quote('%' . $db->escape($text, true) . '%', false);

		
	  $rows = array();
     
    if($users) {
      $rows = array_merge((array)$rows, (array)$this->getUsers($text, $order, $limit));
    }   
   
    if($photos) {
      $rows = array_merge((array)$rows, (array)$this->getPhotos($text, $order, $limit));   
    }    
    
    if($groups) {
      $rows = array_merge((array)$rows, (array)$this->getGroups($text, $order, $limit));   
    }
    
    if($albums) {
      $rows = array_merge((array)$rows, (array)$this->getAlbums($text, $order, $limit));   
    }


    
    
		return $rows;
	}
  
  function getUsers($text, $order, $limit) {
    $db = JFactory::getDBO();
    $query = $db->getQuery(true);
  		$query->select(
  			'a.name AS title, a.username AS text, b.user_id as id, '
  				. '\'2\' AS browsernav'
  		);
  		$query->from('#__users AS a');
  		$query->join('INNER', '#__social_users AS b ON a.id = b.user_id');
   
		  $query->where( 'b.state = 1');
		  $query->where( 'a.block = 0');
    
  		$query->where(
  				'(a.name LIKE ' . $text . ' OR a.username LIKE ' . $text .  ')'
  			);
  		$query->order($order);
  
  		$db->setQuery($query, 0, $limit);
  		//echo $query->__toString();
  		$rows = $db->loadObjectList();
    
  		if ($rows)
  		{
  			foreach ($rows as $key => $row)
  			{
  				$rows[$key]->href = 'index.php?option=com_easysocial&view=profile&id=' . $row->id;
         
            //$rows[$key]->image = JURI::root()."media/com_easysocial/avatars/users/".$row->id."/".$row->img;
            $rows[$key]->image = $this->getImg($row->id, "user", "users");
            
  			}
  		}
     return $rows;    
  }
  
function getImg($id, $type, $linktype) {
	$db = JFactory::getDBO();
	$query =  "SELECT i.square AS img FROM #__social_avatars AS i WHERE i.uid = '".$id."' AND i.type = '".$type."' ";
	
	$db->setQuery($query);
	$result = $db->loadResult();
	if($result)
		return JURI::root()."media/com_easysocial/avatars/".$linktype."/".$id."/".$result;
	else return "";
}
  
  function getPhotos($text, $order, $limit) {
    $db = JFactory::getDBO();
    $query = $db->getQuery(true);
  		$query->select(
  			'img.id AS id, album.title AS title, img.caption AS text, meta.value AS img, img.user_id AS userid, img.title AS imgtitle, u.name AS username,'
  				. '\'2\' AS browsernav'
  		);
  		$query->from('#__social_photos AS img');
  		$query->join('LEFT', '#__social_albums AS album ON img.album_id = album.id');
      $query->join('LEFT', '#__social_photos_meta AS meta ON meta.photo_id = img.id');
      $query->join('LEFT', '#__users AS u ON u.id = img.user_id');
		  $query->where( 'img.state = 1');
      $query->where( 'meta.property = "large"');
  		$query->where(
  				'(img.title LIKE ' . $text . ' OR img.caption LIKE ' . $text .  ')'
  			);
      $query->group('img.album_id', 'img.id');	
  
  		$db->setQuery($query, 0, $limit);
  		$rows = $db->loadObjectList();
  		if ($rows)
  		{
  			foreach ($rows as $key => $row)
  			{
		      $rows[$key]->href	= 'index.php?option=com_easysocial&view=photos&layout=item&id=' . $row->id.":".str_replace(".", "-", $row->imgtitle). '&type=user&uid=' . $row->userid . ":".str_replace(" ", "-", strtolower($row->username));
          if($row->img) {
            $rows[$key]->image = str_replace(JPATH_SITE, JURI::root(), $row->img);
          }   
  			}
  		}
    return $rows;
  }
  
  function getGroups($text, $order, $limit) {
    $db = JFactory::getDBO();
    $query = $db->getQuery(true);     
      $query->select(
  			'grp.id AS id, grp.title AS title, grp.description AS text, grp.alias AS alias, '
  				. '\'2\' AS browsernav'
  		);
  		$query->from('#__social_clusters AS grp');
  		
		  $query->where( 'grp.state = "1"');
      
  		$query->where(
  				'(grp.title LIKE ' . $text . ' OR grp.description LIKE ' . $text .  ')'
  			);  
  		$db->setQuery($query, 0, $limit);
  		$rows = $db->loadObjectList();
  		if ($rows)
  		{
  			foreach ($rows as $key => $row)
  			{
            $rows[$key]->href = 'index.php?option=com_easysocial&view=groups&id=' . $row->id. ":". $row->alias . '&layout=item';
         // if($row->img) {
            //$rows[$key]->image = JURI::root()."media/com_easysocial/avatars/group/".$row->id."/".$row->img;
	$rows[$key]->image = $this->getImg($row->id, "group", "group");
         // }   
  			}
  		}
    return $rows;
  }  


  function getAlbums($text, $order, $limit) {
    $db = JFactory::getDBO();
    $query = $db->getQuery(true); 
    
  		$query->select(
  			'album.id AS id, album.title AS title, album.caption AS text, meta.value AS img, album.user_id AS userid, u.name AS username,'
  				. '\'2\' AS browsernav'
  		);
  		$query->from('#__social_albums AS album');
  		$query->join('LEFT', '#__social_photos AS img ON img.album_id = album.id');
      $query->join('LEFT', '#__social_photos_meta AS meta ON meta.photo_id = img.id');
      $query->join('LEFT', '#__users AS u ON u.id = album.user_id');
		  $query->where( 'img.state = 1');
      $query->where( 'meta.property = "large"');
  		$query->where(
  				'(album.title LIKE ' . $text . ' OR album.caption LIKE ' . $text .  ')'
  			);
      $query->group('img.album_id', 'img.id');	
  
  		$db->setQuery($query, 0, $limit);
  		$rows = $db->loadObjectList();
  		if ($rows)
  		{
  			foreach ($rows as $key => $row)
  			{
		      $rows[$key]->href	= 'index.php?option=com_easysocial&view=albums&layout=item&id=' . $row->id.":".str_replace(".", "-", $row->title). '&type=user&uid=' . $row->userid . ":".str_replace(" ", "-", strtolower($row->username));
          if($row->img) {
            $rows[$key]->image = str_replace(JPATH_SITE, JURI::root(), $row->img);
          }   
  			}
  		}
    return $rows;
  }  
  
}