<?php
/*
 * @package		Joomla.Framework
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 *
 * @component Phoca Plugin
 * @copyright Copyright (C) Marcinko Ernest www.offlajn.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU General Public License version 2 or later;
 */

defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.plugin.plugin' );

if(!version_compare(JVERSION,'1.6.0','ge')) {
	$mainframe->registerEvent('onSearch', 'plgSearchJobboard');
	$mainframe->registerEvent('onSearchAreas', 'plgSearchJobboardAreas');
}

/*
Joomla 1.5
*/

function plgSearchJobboardAreas() {
	static $areas = array(
		'jobboard' => 'Job Board Search plugin'
		);
		return $areas;
}


function plgSearchJobboard( $text, $phrase = '', $ordering = '', $areas = null ) {
  $db = & JFactory::getDBO(); 
	$words = explode(' ', $text);
	$wheres = array();
	foreach ($words as $word) {
		$word = $db->Quote('%' . $db->getEscaped($word, true) . '%', false);
		$wheres2 = array();
		$wheres2[] = 'job_title LIKE ' . $word;
		$wheres2[] = 'description LIKE ' . $word;
		$wheres2[] = 'job_tags LIKE ' . $word;
		$wheres[] = implode(' OR ', $wheres2);
	}
	$where = '(' . implode(($phrase == 'all' ? ') AND (' : ') OR ('), $wheres) . ')';
  $sql = "SELECT id, job_title as title, description as text FROM #__jobboard_jobs WHERE ".$where;

	$db->setQuery($sql);
	$rows = $db->loadObjectList();
	if ($rows) {
		foreach ($rows as $key => $row) {
			$rows[$key]->href = JRoute::_(JUri::Root().'index.php?option=com_jobboard&view=job&catid=1&lyt=list&id=' . $row->id);
		}
	}
  return $rows;
}


class plgSearchJobboard extends JPlugin
{

	public function __construct(& $subject, $config) {
		parent::__construct($subject, $config);
	}
	
	function onContentSearchAreas() {

		static $areas = array(
			'jobboard' => 'Job Board Search plugin'
			);
			return $areas;
	}

  function onContentSearch( $text, $phrase = '', $ordering = '', $areas = null ) {
    $db = & JFactory::getDBO(); 
  	$words = explode(' ', $text);
  	$wheres = array();
  	foreach ($words as $word) {
  		$word = $db->Quote('%' . $db->getEscaped($word, true) . '%', false);
  		$wheres2 = array();
  		$wheres2[] = 'job_title LIKE ' . $word;
  		$wheres2[] = 'description LIKE ' . $word;
  		$wheres2[] = 'job_tags LIKE ' . $word;
  		$wheres[] = implode(' OR ', $wheres2);
  	}
  	$where = '(' . implode(($phrase == 'all' ? ') AND (' : ') OR ('), $wheres) . ')';
    $sql = "SELECT id, job_title as title, description as text FROM #__jobboard_jobs WHERE ".$where;
 
  	$db->setQuery($sql);
  	$rows = $db->loadObjectList();
  	if ($rows) {
  		foreach ($rows as $key => $row) {
  			$rows[$key]->href = JRoute::_(JUri::Root().'index.php?option=com_jobboard&view=job&catid=1&lyt=list&id=' . $row->id);
  		}
  	}
    return $rows;
	}
}