<?php

/**
 * @version		$Id: virtuemart.php $
 * @package		Joomla
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.plugin' ) ;
if (!class_exists( 'VmConfig' )) require(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_virtuemart'.DS.'helpers'.DS.'config.php');
$config= VmConfig::loadConfig();
if(!class_exists('TableCategories')) require(JPATH_VM_ADMINISTRATOR.DS.'tables'.DS.'categories.php');
if (!class_exists( 'VirtueMartModelCategory' )) require(JPATH_VM_ADMINISTRATOR.DS.'models'.DS.'category.php');
if (!class_exists( 'VirtueMartModelProduct' )) require(JPATH_VM_ADMINISTRATOR.DS.'models'.DS.'product.php');
  
$show_prices = VmConfig::get('show_prices', 1);
  if ($show_prices == '1') {
    if (!class_exists('calculationHelper'))
      require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'calculationh.php');
	 if (!class_exists('CurrencyDisplay'))
		  require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'currencydisplay.php');
	}  

if(!version_compare(JVERSION,'1.6.0','ge')) {
	$mainframe->registerEvent('onSearch', 'plgSearchVmxsearch');
	$mainframe->registerEvent('onSearchAreas', 'plgSearchVmxsearchAreas');
}

function &plgSearchVmxsearchAreas() {
	static $areas = array(
'vmxsearch' => 'Products'
	);
	return $areas;
}

function plgSearchVmxsearch($text, $phrase='', $ordering='', $areas=null) {
	$db = & JFactory::getDBO();
	$user = & JFactory::getUser();
	if (is_array($areas)) {
		if (!array_intersect($areas, array_keys(plgSearchVmxsearchAreas()))) {
			return array();
		}
	}

	// load plugin params info
	$plugin = & JPluginHelper::getPlugin('search', 'vmxsearch');
	$pluginParams = new JParameter($plugin->params);

	$limit = $pluginParams->def('search_limit', 50);


	$text = trim($text);
	if ($text == '') {
		return array();
	}

	$section = JText::_('Products');
	$wheres = array();
	switch ($phrase) {
		case 'exact':
			$text = $db->Quote('%' . $db->getEscaped($text, true) . '%', false);
			$wheres2 = array();
			$wheres2[] = 'a.product_sku LIKE ' . $text;
			$wheres2[] = 'p.product_name LIKE ' . $text;
			$wheres2[] = 'p.product_s_desc LIKE ' . $text;
			$wheres2[] = 'p.product_desc LIKE ' . $text;
			$wheres2[] = 'b.category_name LIKE ' . $text;
			$where = '(' . implode(') OR (', $wheres2) . ')';
			break;

		case 'all':
		case 'any':
		default:
			$words = explode(' ', $text);
			$wheres = array();
			foreach ($words as $word) {
				$word = $db->Quote('%' . $db->getEscaped($word, true) . '%', false);
				$wheres2 = array();
				$wheres2[] = 'a.product_sku LIKE ' . $word;
				$wheres2[] = 'p.product_name LIKE ' . $word;
				$wheres2[] = 'p.product_s_desc LIKE ' . $word;
				$wheres2[] = 'p.product_desc LIKE ' . $word;
				$wheres2[] = 'b.category_name LIKE ' . $word;
				$wheres[] = implode(' OR ', $wheres2);
			}
			$where = '(' . implode(($phrase == 'all' ? ') AND (' : ') OR ('), $wheres) . ')';
			break;
	}
	switch ($ordering) {
		case 'alpha':
			$order = 'p.product_name ASC';
			break;

		case 'category':
			$order = 'b.category_name ASC, a.product_name ASC';
			break;

		case 'popular':
  		$order = 'a.hits DESC';
			break;
		case 'newest':
			$order = 'a.created_on DESC';
			break;
		case 'oldest':
			$order = 'a.created_on ASC';
			break;
		default:
			$order = 'p.product_name DESC';
	}

	$text = $db->Quote('%' . $db->getEscaped($text, true) . '%', false);
 	$query = "SELECT DISTINCT CONCAT( p.product_name,' (',a.product_sku,')' ) AS title, a.virtuemart_product_id , b.virtuemart_category_id ,   p.product_s_desc   AS text, b.category_name as section,
  		 a.created_on as created, '2' AS browsernav,
       (SELECT m.file_url AS path
                  FROM #__virtuemart_medias AS m
                    LEFT JOIN #__virtuemart_product_medias AS me ON m.virtuemart_media_id = me.virtuemart_media_id
                    WHERE me.virtuemart_product_id = a.virtuemart_product_id ORDER BY me.ordering ASC LIMIT 1 ) AS image
  		FROM #__virtuemart_products AS a
  		LEFT JOIN #__virtuemart_products_".VMLANG." p ON p.virtuemart_product_id = a.virtuemart_product_id 
  		LEFT JOIN #__virtuemart_product_categories AS xref ON xref.virtuemart_product_id = a.virtuemart_product_id
  		LEFT JOIN #__virtuemart_categories_".VMLANG." AS b ON b.virtuemart_category_id = xref.virtuemart_category_id
      LEFT JOIN #__virtuemart_product_medias AS pm ON pm.virtuemart_product_id = (SELECT IF(a.product_parent_id>0, a.product_parent_id, p.virtuemart_product_id))
  	  LEFT JOIN #__virtuemart_medias AS media ON pm.virtuemart_media_id = media.virtuemart_media_id
  	  LEFT JOIN #__virtuemart_product_customfields AS c ON p.virtuemart_product_id = c.virtuemart_product_id"
  	. ' WHERE (' . $where . ') AND a.published = 1 AND a.product_parent_id = "0" '
    .' GROUP BY a.virtuemart_product_id '
  	. ' ORDER BY pm.ordering,' . $order
  	;
  	$db->setQuery($query, 0, $limit);
  	$rows = $db->loadObjectList();

	if ($rows) {
		foreach ($rows as $key => $row) {
			$rows[$key]->href = 'index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $row->virtuemart_product_id . '&virtuemart_category_id=' . $row->virtuemart_category_id;
			// $rows[$key]->text = $text;
		}
	}
	return $rows;
}

class plgSearchVmxsearch extends JPlugin
{
	function onContentSearchAreas() {

		static $areas = array(
	'virtuemart' => 'Products'
		);
		return $areas;
	}

	/**
	 * virtuemart Products Search method
	 *
	 * The sql must return the following fields that are used in a common display
	 * routine: href, title, section, created, text, browsernav
	 * @param string Target search string
	 * @param string mathcing option, exact|any|all
	 * @param string ordering option, newest|oldest|popular|alpha|category
	 */
	function onContentSearch($text, $phrase='', $ordering='', $areas=null) {
		$db		= JFactory::getDbo();
		$app	= JFactory::getApplication();
		$user = & JFactory::getUser();
		$groups	= implode(',', $user->getAuthorisedViewLevels());
		$tag = JFactory::getLanguage()->getTag();
		$searchText = $text;

		if (is_array($areas)) {
			if (!array_intersect($areas, array_keys($this->onContentSearchAreas()))) {
				return array();
			}
		}

		// load plugin params info
		// $plugin = & JPluginHelper::getPlugin('search', 'virtuemart');
		// $pluginParams = new JParameter($plugin->params);

		// $limit = $pluginParams->def('search_limit', 50);
		$limit = $this->params->def('search_limit',		50);
    $inStock = $this->params->def('instock', 0);

		/* TO do it work with date
		 $nullDate		= $db->getNullDate();
		$date = JFactory::getDate();
		$now = $date->toMySQL();
		*/

		$text = trim($text);
		if ($text == '') {
			return array();
		}

		$section = JText::_('Products');
		$wheres = array();
  	switch ($phrase) {
  		case 'exact':
  			$text = $db->Quote('%' . $db->getEscaped($text, true) . '%', false);
  			$wheres2 = array();
  			$wheres2[] = 'a.product_sku LIKE ' . $text;
  			$wheres2[] = 'p.product_name LIKE ' . $text;
  			$wheres2[] = 'p.product_s_desc LIKE ' . $text;
  			$wheres2[] = 'p.product_desc LIKE ' . $text;
  			$wheres2[] = 'b.category_name LIKE ' . $text;
  			$wheres2[] = 'c.custom_value LIKE ' . $text;
  			$where = '(' . implode(') OR (', $wheres2) . ')';
  			break;
  
  		case 'all':
  		case 'any':
  		default:
  			$words = explode(' ', $text);
  			$wheres = array();
  			foreach ($words as $word) {
  				$word = $db->Quote('%' . $db->getEscaped($word, true) . '%', false);
  				$wheres2 = array();
  				$wheres2[] = 'a.product_sku LIKE ' . $word;
  				$wheres2[] = 'p.product_name LIKE ' . $word;
  				$wheres2[] = 'p.product_s_desc LIKE ' . $word;
  				$wheres2[] = 'p.product_desc LIKE ' . $word;
  				$wheres2[] = 'b.category_name LIKE ' . $word;
  				$wheres2[] = 'c.custom_value LIKE ' . $word;
  				$wheres[] = implode(' OR ', $wheres2);
  			}
  			$where = '(' . implode(($phrase == 'all' ? ') AND (' : ') OR ('), $wheres) . ')';
  			break;
  	}
  	if( $inStock ) {
  		$where .= " AND a.product_in_stock > 0 ";
  	}
  	
  	switch ($ordering) {
  		case 'alpha':
  			$order = 'p.product_name ASC';
  			break;
  
  		case 'category':
  			$order = 'b.category_name ASC, a.product_name ASC';
  			break;
  
  		case 'popular':
  			$order = 'a.hits DESC';
  			break;
  		case 'newest':
  			$order = 'a.created_on DESC';
  			break;
  		case 'oldest':
  			$order = 'a.created_on ASC';
  			break;
  		default:
  			$order = 'p.product_name DESC';
  	}
		// search product
  	$text = $db->Quote('%' . $db->getEscaped($text, true) . '%', false);
 	$query = "SELECT DISTINCT CONCAT( p.product_name,' (',a.product_sku,')' ) AS title, a.virtuemart_product_id , b.virtuemart_category_id ,   p.product_s_desc   AS text, b.category_name as section,
  		 a.created_on as created, '2' AS browsernav,
       (SELECT m.file_url AS path
                  FROM #__virtuemart_medias AS m
                    LEFT JOIN #__virtuemart_product_medias AS me ON m.virtuemart_media_id = me.virtuemart_media_id
                    WHERE me.virtuemart_product_id = a.virtuemart_product_id ORDER BY me.ordering ASC LIMIT 1 ) AS image
  		FROM #__virtuemart_products AS a
  		LEFT JOIN #__virtuemart_products_".VMLANG." p ON p.virtuemart_product_id = a.virtuemart_product_id 
  		LEFT JOIN #__virtuemart_product_categories AS xref ON xref.virtuemart_product_id = a.virtuemart_product_id
  		LEFT JOIN #__virtuemart_categories_".VMLANG." AS b ON b.virtuemart_category_id = xref.virtuemart_category_id
      LEFT JOIN #__virtuemart_product_medias AS pm ON pm.virtuemart_product_id = (SELECT IF(a.product_parent_id>0, a.product_parent_id, p.virtuemart_product_id))
  	  LEFT JOIN #__virtuemart_medias AS media ON pm.virtuemart_media_id = media.virtuemart_media_id
  	  LEFT JOIN #__virtuemart_product_customfields AS c ON p.virtuemart_product_id = c.virtuemart_product_id"
  	. ' WHERE (' . $where . ') AND a.published = 1 AND a.product_parent_id = "0" '
    .' GROUP BY a.virtuemart_product_id '
  	. ' ORDER BY pm.ordering,' . $order
  	;
  	$db->setQuery($query, 0, $limit);
  	$rows = $db->loadObjectList();
		if ($rows) {
			foreach ($rows as $key => $row) {
				$rows[$key]->href = 'index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $row->virtuemart_product_id . '&virtuemart_category_id=' . $row->virtuemart_category_id;
        $rows[$key]->price = $this->getPrice($row->virtuemart_product_id);
				// $rows[$key]->text = $text;
			}
		}
		return $rows;
	}
  
  function getPrice($pid) {
	 if (!class_exists('CurrencyDisplay')) {
		  require_once(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'currencydisplay.php');
	}  
    $product_model = VmModel::getModel('product');
    $currency = CurrencyDisplay::getInstance();
		$product = $product_model->getProduct($pid,TRUE,TRUE,TRUE,1);
		$p = str_replace("PricesalesPrice", "", $currency->createPriceDiv ('salesPrice', '', $product->prices));
    return $p;
  }
}
