<?php
/**
 * @package     Joomla.Platform
 * @subpackage  HTML
 *
 * @copyright   Copyright (C) 2005 - 2011 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('JPATH_PLATFORM') or die;
jimport('joomla.form.formfield');
/**
 * Renders a text element
 *
 * @package     Joomla.Platform
 * @subpackage  Parameter
 * @since       11.1
 * @deprecated  Use JForm instead
 */
class JFormFieldXtext extends JFormFieldText
{
	/**
	 * Element name
	 *
	 * @var    string
	 */
  var	$type = 'Xtext';
	/**
	 * @deprecated    12.1
	 * @since   11.1
	 *    	 
	 */
  
	protected function getInput() {
		$size		= $this->element['size'] ? ' size="'.(int) $this->element['size'].'"' : '';
		$maxLength	= $this->element['maxlength'] ? ' maxlength="'.(int) $this->element['maxlength'].'"' : '';
		$class		= $this->element['class'] ? ' class="'.(string) $this->element['class'].'"' : '';
		$readonly	= ((string) $this->element['readonly'] == 'true') ? ' readonly="readonly"' : '';
		$disabled	= ((string) $this->element['disabled'] == 'true') ? ' disabled="disabled"' : '';

		// Initialize JavaScript field attributes.
		$onchange	= $this->element['onchange'] ? ' onchange="'.(string) $this->element['onchange'].'"' : '';

		return '<input type="text" name="'.$this->name.'" id="'.$this->id.'"' .
			' value="'.htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8').'"' .
			$class.$size.$disabled.$readonly.$onchange.$maxLength.'/>&nbsp;&nbsp;<input type="button" value="Get an Api key" onclick="window.location.href=\'https://code.google.com/apis/console/\';" />&nbsp;&nbsp;<input type="button" value="More info" onclick="window.location.href=\'http://offlajn.com/blog/entry/2012/01/12/google-site-search-plugin.html\';" />';
	}
}
