<?php
/** 

 * Modified by Jason Williams - Ris.so
 *  
 * redSHOP can be downloaded from www.redcomponent.com
 * redSHOP is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 *
 * change log:
 *  Now works with Joomla 1.7+
 *	Includes option to remove child products
 * 	limits how many products can be pulled from Redshop
 *	Shop Name override
 * 	Bugfixes
 *   
 * You should have received a copy of the GNU General Public License
 * along with redSHOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.plugin.plugin');

class plgSearchredshop_products extends JPlugin
{

	function onContentSearchAreas()
	{	
	
		$shop_name = $this->params->get('shop_name', 'Shop');
		static $areas;
		$areas = array( 
			'redshop_products' => $shop_name
		);
		return $areas;
	}
	
	
	function onContentSearch($text, $phrase='', $ordering='', $areas=null)
	{
		JPlugin::loadLanguage( 'plg_search_redshop_products' );
		require_once JPATH_SITE.'/components/com_redshop/helpers/helper.php'; 
		require_once JPATH_SITE.'/administrator/components/com_search/helpers/search.php';
			
		$db		=& JFactory::getDBO();
		$user	=& JFactory::getUser();
		$searchText = $text;
	
		//If the array is not correct, return it:
		if (is_array($areas)) {
			if (!array_intersect($areas, array_keys($this->onContentSearchAreas()))) {
				return array();
			}
		}
	
		// load plugin params info
		$limit = $this->params->get('search_limit', 50);
		$limit = trim($limit);
		
		$child_products = $this->params->get('child_products', 0);
		
		
		
		// Include child products in search?
		$product_children = ($child_products) ? '' : ' AND a.product_parent_id = 0';
		
	
		$text = trim( $text );
		if ($text == '') {
			return array();
		}
		$section 	= JText::_( 'Products' );
		
		$wheres 	= array();
		switch ($phrase)
		{
			case 'exact':
				$text		= $db->Quote( '%'.$db->getEscaped( $text, true ).'%', false );
				$wheres2 	= array();
				$wheres2[] 	= 'a.product_name LIKE '.$text;
				 
				$where 		= '(' . implode( ') OR (', $wheres2 ) . ')';
				break;
	
			case 'all':
			case 'any':
			default:
				$words 	= explode( ' ', $text );
				$wheres = array();
				foreach ($words as $word)
				{
					$word		= $db->Quote( '%'.$db->getEscaped( $word, true ).'%', false );
					$wheres2 	= array();
					$wheres2[] 	= 'a.product_name LIKE '.$word;
			 
					$wheres[] 	= implode( ' OR ', $wheres2 );
				}
				$where 	= '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
				break;
		}
				
		
		switch ( $ordering )
		{
			case 'oldest':
				 $order = 'a.product_id ASC';
				 break;
	 
			case 'newest':
				
			default:
				$order = 'a.product_id DESC';
		}
	
		  $query = 'SELECT a.product_id, a.publish_date, a.product_name AS title, a.product_s_desc AS text, a.product_full_image,'
	 
		. ' "2" AS browsernav,'
		. ' "REDSHOP" AS section, '
		. ' "" as created'
		. ' FROM #__redshop_product AS a'
		 
		. ' WHERE ('. $where .')'
		. ' AND a.published = 1'
		. $product_children
		 
		. ' ORDER BY '. $order
		;
		
		 //error_reporting(E_ALL);
		 //ini_set('display_errors','On');
		
		$db->setQuery( $query, 0, $limit );
		$rows = $db->loadObjectList();
				
		$redhelper = new redhelper();
		foreach($rows as $key => $row) {
			$Itemid = $redhelper->getItemid($row->product_id);
			$rows[$key]->href =  "index.php?option=com_redshop&view=product&pid=".$row->product_id."&Itemid=".$Itemid;
			$rows[$key]->product_full_image = JURI::root(false)."components/com_redshop/assets/images/product/".$row->product_full_image;
			// REMOVE TIME FROM DATE
			$publish_date = substr($row->publish_date, '0', '10');
			$rows[$key]->created = $publish_date;			
			
			// NOW WE GRAB THE CATEEGORY FOR EACH PRODUCT::
			$product_id = $row->product_id;			
			$cat_query = 'SELECT category_id FROM #__redshop_product_category_xref WHERE product_id = ' . $product_id;
			$db->setQuery($cat_query);
			$cat_id = $db->loadResult();
			
			$cat_query2 = 'SELECT category_name FROM #__redshop_category WHERE category_id = ' . $cat_id;
			$db->setQuery($cat_query2);
			$cat_name = $db->loadResult();
			// If the product has no parent category, use the shop name entered in the params
			$shop_name = $this->params->get('shop_name', 'Shop');
			$rows[$key]->section = ($cat_name) ? $cat_name : $shop_name;
			
		}
	
		$return = array();
		foreach($rows AS $key => $weblink) {
			if(searchHelper::checkNoHTML($weblink, $searchText, array('url', 'text', 'title'))) {
				$return[] = $weblink;
			}
		}
	
		return $return;
		
	}// end of function
}