<?php
/**
 * @version   $Id: jssearch.php 1.6 - 24.05.2011
 * @copyright (C) 2010 by G-IT-Solutions - All rights reserved!
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @author Norbert Graup & Sebastian Graup
 * @modify Janos Biro http://offlajn.com 
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.html.parameter' );

$mainframe =& JFactory::getApplication();

if(version_compare(JVERSION,'1.6.0','<')){
	$mainframe->registerEvent( 'onSearch', 'plgCommunitySearchjscustomsearch' );
	$mainframe->registerEvent( 'onSearchAreas', 'plgCommunitySearchjssearchAreas' );
}else{
	$mainframe->registerEvent( 'onContentSearch', 'plgCommunitySearchjscustomsearch' );
	$mainframe->registerEvent( 'onContentSearchAreas', 'plgCommunitySearchjssearchAreas' );
}

$lang =& JFactory::getLanguage();
$lang->load('plg_search_jssearch', JPATH_ADMINISTRATOR);

//Function to show this search in the search areas.
function plgCommunitySearchjssearchAreas()
{
        static $areas = array(
                'jssearch' => 'Jomsocial'
        );
        return $areas;
}

//Search function and DB connection
//The function will be closed with an } at the end of the file.
function plgCommunitySearchjscustomsearch( $text, $phrase='', $ordering='', $areas=null )
{
        $db    =& JFactory::getDBO();
        $user  =& JFactory::getUser(); 
 
//If the array is not correct, return it:
        if (is_array( $areas )) {
                if (!array_intersect( $areas, array_keys( plgCommunitySearchjssearchAreas() ) )) {
                        return array();
                }
        }
		
//Define the parameters
$plugin =& JPluginHelper::getPlugin('search', 'jssearch');
 
//Load the Plugin parameters
$pluginParams = new JParameter( $plugin->params );
 
//Plugin parameters
$limit = $pluginParams->def( 'limit', 50 );
$hideSuperadmin	= $pluginParams->def( 'hide_superadmin', 1 );

// Extended search parameters custom profiles
$searchAll = $pluginParams->def( 'search_all', 1 );
$sfield1 = $pluginParams->def( 'search_field1', "");
$sfield2 = $pluginParams->def( 'search_field2', "");
$sfield3 = $pluginParams->def( 'search_field3', "");
$sfield4 = $pluginParams->def( 'search_field4', "");
$sfield5 = $pluginParams->def( 'search_field5', "");

// Parameters for searches
$sAlbums = 		$pluginParams->def( 'search_albums', 0);
$sBulletins = 	$pluginParams->def( 'search_bulletins', 0);
$sDiscussions = $pluginParams->def( 'search_discussions', 0);
$sGroups = 		$pluginParams->def( 'search_groups', 0);
$sPhotos = 		$pluginParams->def( 'search_photos', 0);
$sVideos = 		$pluginParams->def( 'search_videos', 0);
$sEvents =		$pluginParams->def( 'search_events', 0);

// Parameters for Privacy
$opUsers = 			$pluginParams->def( 'search_users_privacy', 0);
$opAlbums = 		$pluginParams->def( 'search_albums_privacy', 0);
$opBulletins = 		$pluginParams->def( 'search_bulletins_privacy', 0);
$opDiscussions = 	$pluginParams->def( 'search_discussions_privacy', 0);
$opGroups = 		$pluginParams->def( 'search_groups_privacy', 0);
$opPhotos = 		$pluginParams->def( 'search_photos_privacy', 0);
$opVideos = 		$pluginParams->def( 'search_videos_privacy', 0);
$opEvents =			$pluginParams->def( 'search_events_privacy', 0);

// Show user real name
$showUserRealName = $pluginParams->def( 'search_show_user_realname', 0);

// Show pictures
$showPictures = $pluginParams->def( 'search_show_pictures', 0);

//Delete spaces in front of and/or at the end of the searching terms
$text = trim( $text );

//Return Array when nothing was filled in
if ($text == '') {
                return array();
        }
 
//DB part
        $wheres = array();
        switch ($phrase) {

//Exact Search
        case 'exact':
			$text		= $db->Quote( '%'.$db->getEscaped( $text, true ).'%', false );
			$wheres2 	= array();
			if ($showUserRealName) $wheres2[] 	= 'j.name LIKE '.$text;
			$wheres2[] 	= 'j.username LIKE '.$text;
			$wheres2[] 	= 'j.email LIKE '.$text;
			$wheres2[] 	= 'c.status LIKE '.$text;
			$wheres2[]  = 'fv.value LIKE '.$text;
			$wheres2[] 	= 'd.comment LIKE '.$text;
			$where 		= '(' . implode( ') OR (', $wheres2 ) . ')';
			break;
 
//Search all or any
            case 'all':
            case 'any':
 
//Default
		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$word		= $db->Quote( '%'.$db->getEscaped( $word, true ).'%', false );
				$wheres2 	= array();
				if ($showUserRealName) $wheres2[] 	= 'j.name LIKE '.$word;
				$wheres2[] 	= 'j.username LIKE '.$word;
				$wheres2[] 	= 'j.email LIKE '.$word;
				$wheres2[] 	= 'c.status LIKE '.$word;
				$wheres2[]  = 'fv.value LIKE '.$word;
				$wheres2[] 	= 'd.comment LIKE '.$word;
				$wheres2[] 	= 'x.title LIKE '.$word;
				$wheres[] 	= implode( ' OR ', $wheres2 );
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}

//Result Ordering
        switch ( $ordering ) {
 
                case 'alpha':
                        $order = 'j.name ASC';
                        break;
                case 'oldest':
                case 'popular':
                case 'newest':
                default:
                        $order = 'j.name ASC';
        }
 
//Replace Name of Plugin
        $SearchJssearch = JText::_( 'JSSEARCHNAME' );

// Hide Super Admins by default
	$usersFilter = ($hideSuperadmin) ? ' AND j.gid <> 25 ' : '';
	
// Build clause for extra 5 fields to search in if not search all
	$extrafields = ($searchAll) ? '' : "and (f.fieldcode = '" . $sfield1 . "' or f.fieldcode = '" . $sfield2 . "' or f.fieldcode = '" . $sfield3 . "' or f.fieldcode = '" . $sfield4 . "' or f.fieldcode = '" . $sfield5 . "')";
	$extrawhere = ($searchAll) ? ' WHERE ' . $where : ' WHERE (' . $where . ') ';
	
// Add User Privacy
$pUsers = '';
if($opUsers)
	$pUsers = " AND c.params LIKE '%privacyProfileView=0%' ";
	
// User name or real name
$name = 'j.username AS title, ';
if($showUserRealName)
	$name = 'j.name AS title, ';
	
// Show pictures
$picture = '';
if($showPictures)
	$picture = 'c.thumb AS image, ';

// Query and output	
	$query	= 'SELECT j.id AS id, ' . $name . ' c.status AS text, ' . $picture
			. ' "" AS created, "Community" AS section, "2" AS browsernav'
			. ' FROM ' . $db->nameQuote('#__community_users') . ' AS c'
			. ' INNER JOIN ' . $db->nameQuote('#__users') . ' AS j ON j.id = c.userid'
			. ' LEFT JOIN ' . $db->nameQuote('#__community_fields_values') . ' AS fv ON fv.user_id = c.userid'
			. ' LEFT JOIN ' . $db->nameQuote('#__community_fields') . ' AS f ON f.id = fv.field_id'
			. ' LEFT JOIN ' . $db->nameQuote('#__community_wall') . ' AS d ON d.contentid = c.userid AND d.type LIKE "user"'
			. ' LEFT JOIN ' . $db->nameQuote('#__community_activities') . ' AS x ON x.actor = c.userid AND x.comment_type = "profile.status"'
			. $extrawhere
			. $extrafields
			. ' AND j.block = ' . $db->quote(0)
			. $usersFilter
			. $pUsers
			. ' GROUP BY j.id'
			. ' ORDER BY ' . $order;
	$db->setQuery( $query, 0, $limit );
	$rows = $db->loadObjectList();

	if ($rows)
	{
		$comunityLib	= JPATH_ROOT . DS . 'components' . DS . 'com_community' . DS . 'libraries' . DS . 'core.php';
		include_once($comunityLib);
	
		foreach($rows as $key => $row) {
			$rows[$key]->href		= CRoute::_('index.php?option=com_community&view=profile&userid='.$row->id);
			if($showPictures)
        $rows[$key]->add_path=true;
		}
	}
	
	$result = $rows;
	
	if($sAlbums)
		$result = array_merge((array)$result, (array)plgCommunitySearchAlbums($text, '', '', null, $limit, $opAlbums, $showPictures));
	
	if($sBulletins)
		$result = array_merge((array)$result, (array)plgCommunitySearchBulletins($text, '', '', null, $limit, $opBulletins, $showPictures));
	
	if($sDiscussions)
		$result = array_merge((array)$result, (array)plgCommunitySearchDiscussions($text, '', '', null, $limit, $opDiscussions, $showPictures));
	
	if($sGroups)
		$result = array_merge((array)$result, (array)plgCommunitySearchGroups($text, '', '', null, $limit, $opGroups, $showPictures));
	
	if($sPhotos)
		$result = array_merge((array)$result, (array)plgCommunitySearchPhotos($text, '', '', null, $limit, $opPhotos, $showPictures));
	
	if($sVideos)
		$result = array_merge((array)$result, (array)plgCommunitySearchVideos($text, '', '', null, $limit, $opVideos, $showPictures));
	
	if($sEvents)
		$result = array_merge((array)$result, (array)plgCommunitySearchEvents($text, '', '', null, $limit, $opEvents, $showPictures));
	
	return $result;
}

function plgCommunitySearchAlbums( $text, $phrase='', $ordering='', $areas=null, $limit, $opAlbums, $showPictures)
{
	$db		=& JFactory::getDBO();
	$user	=& JFactory::getUser();

	switch ( $ordering )
	{
		case 'alpha':
			$order = 'p.name ASC';
			break;
		case 'category':
			$order = 'c.name ASC';
			break;
		case 'newest':
			$order = 'p.created DESC';
			break;
		case 'oldest':
			$order = 'p.created ASC';
			break;
		default:
			$order = 'p.name DESC';
			break;
	}

	$text = trim( $text );
	if ($text == '') {
		return array();
	}

	switch ($phrase)
	{
		case 'exact':
			$text		= $db->Quote( '%'.$db->getEscaped( $text, true ).'%', false );
			$wheres2 	= array();
			$wheres2[] 	= 'p.name LIKE '.$text;
			$wheres2[] 	= 'p.description LIKE '.$text;
			$where 		= '(' . implode( ') OR (', $wheres2 ) . ')';
			break;

		case 'all':
		case 'any':
		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$word		= $db->Quote( '%'.$db->getEscaped( $word, true ).'%', false );
				$wheres2 	= array();
				$wheres2[] 	= 'p.name LIKE '.$word;
				$wheres2[] 	= 'p.description LIKE '.$word;
				$wheres[] 	= implode( ' OR ', $wheres2 );
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}
	
// Add Album Privacy
$pAlbums = '';
if($opAlbums)
	$pAlbums = "AND p.permissions = 0";
	
// Show pictures
$picture = '';
if($showPictures)
	$picture = 'z.thumbnail as image, ';
	
	$query	= 'SELECT p.id, p.photoid, p.creator, p.groupid, p.created AS created, p.name AS title, c.name as category, p.description as text, ' . $picture
			. ' CONCAT_WS("/", "'.JText::_( 'Albums' ).'", c.name) AS section'
			. ' FROM ' . $db->nameQuote('#__community_photos_albums') . ' AS p'
			. ' INNER JOIN ' . $db->nameQuote('#__users') . ' AS c ON c.id = p.creator'
			. ' LEFT JOIN ' . $db->nameQuote('#__community_photos') . ' AS z ON z.id = p.photoid'
			. ' WHERE ' . $where
			. $pAlbums
			. ' GROUP BY p.id'
			. ' ORDER BY ' . $order;
	$db->setQuery( $query, 0, $limit );
	$rows = $db->loadObjectList();

	$comunityLib	= JPATH_ROOT . DS . 'components' . DS . 'com_community' . DS . 'libraries' . DS . 'core.php';
	include_once($comunityLib);

	foreach($rows as $key => $row) {
		
		if ($row->groupid == 0 ) {
		$rows[$key]->href		= CRoute::_('index.php?option=com_community&view=photos&task=album&albumid='.$row->id.'&userid='.$row->creator);
		$rows[$key]->browsernav	= 2;
		}
		else {
		$rows[$key]->href		= CRoute::_('index.php?option=com_community&view=photos&task=album&albumid='.$row->id.'&groupid='.$row->groupid);
		$rows[$key]->browsernav	= 2;		}
	}

	return $rows;
}

// gehört zu Groups - todo Privacy
function plgCommunitySearchBulletins( $text, $phrase='', $ordering='', $areas=null, $limit, $opBulletins, $showPictures)
{
	$db		=& JFactory::getDBO();
	$user	=& JFactory::getUser();
	
	switch ( $ordering )
	{
		case 'alpha':
			$order = 'p.title ASC';
			break;
		case 'category':
			$order = 'c.name ASC';
			break;
		case 'newest':
			$order = 'p.date DESC';
			break;
		case 'oldest':
			$order = 'p.date ASC';
			break;
		default:
			$order = 'p.title DESC';
			break;
	}
	
	$text = trim( $text );
	if ($text == '') {
		return array();
	}
	
	switch ($phrase)
	{
		case 'exact':
			$text		= $db->Quote( '%'.$db->getEscaped( $text, true ).'%', false );
			$wheres2 	= array();
			$wheres2[] 	= 'p.title LIKE '.$text;
			$wheres2[] 	= 'p.message LIKE '.$text;
			$where 		= '(' . implode( ') OR (', $wheres2 ) . ')';
			break;
		case 'all':
		case 'any':
		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$word		= $db->Quote( '%'.$db->getEscaped( $word, true ).'%', false );
				$wheres2 	= array();
				$wheres2[] 	= 'p.title LIKE '.$word;
				$wheres2[] 	= 'p.message LIKE '.$word;
				$wheres[] 	= implode( ' OR ', $wheres2 );
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}

// Add Bulletin Privacy
$pBulletins = '';
if($opBulletins)
	$pBulletins = "AND p.permissions = 0";
	
// Show pictures
$picture = '';
if($showPictures)
	$picture = 'c.thumb as image, ';

	$query	= 'SELECT p.id, p.groupid, p.date AS created, p.title AS title, p.message AS text, c.name as category, ' . $picture
			. ' CONCAT_WS("/", "'.JText::_( 'Bulletins' ).'", c.name) AS section'
			. ' FROM ' . $db->nameQuote('#__community_groups_bulletins') . ' AS p'
			. ' INNER JOIN ' . $db->nameQuote('#__community_groups') . ' AS c ON c.id = p.groupid'
			. ' WHERE ' . $where
			. ' GROUP BY p.id'
			. ' ORDER BY ' . $order;
	$db->setQuery( $query, 0, $limit );
	$rows = $db->loadObjectList();

	$comunityLib	= JPATH_ROOT . DS . 'components' . DS . 'com_community' . DS . 'libraries' . DS . 'core.php';
	include_once($comunityLib);

	foreach($rows as $key => $row) {
		$rows[$key]->href		= CRoute::_('index.php?option=com_community&view=groups&task=viewbulletin&groupid='.$row->groupid.'&bulletinid='.$row->id);
		$rows[$key]->browsernav	= 2;
	}

	return $rows;
}

// gehört zu Groups - todo Privacy
function plgCommunitySearchDiscussions( $text, $phrase='', $ordering='', $areas=null, $limit, $opDiscussions, $showPictures)
{
	$db		=& JFactory::getDBO();
	$user	=& JFactory::getUser();

	switch ( $ordering )
	{
		case 'alpha':
			$order = 'p.title ASC';
			break;
		case 'category':
			$order = 'c.name ASC';
			break;
		case 'newest':
			$order = 'p.created DESC';
			break;
		case 'oldest':
			$order = 'p.created ASC';
			break;
		default:
			$order = 'p.title DESC';
			break;
	}

	$text = trim( $text );
	if ($text == '') {
		return array();
	}

	switch ($phrase)
	{
		case 'exact':
			$text		= $db->Quote( '%'.$db->getEscaped( $text, true ).'%', false );
			$wheres2 	= array();
			$wheres2[] 	= 'p.title LIKE '.$text;
			$wheres2[] 	= 'd.comment LIKE '.$text;
			$wheres2[] 	= 'p.message LIKE '.$text;
			$where 		= '(' . implode( ') OR (', $wheres2 ) . ')';
			break;

		case 'all':

		case 'any':

		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$word		= $db->Quote( '%'.$db->getEscaped( $word, true ).'%', false );
				$wheres2 	= array();
				$wheres2[] 	= 'p.title LIKE '.$word;
				$wheres2[] 	= 'd.comment LIKE '.$word;
				$wheres2[] 	= 'p.message LIKE '.$word;
				$wheres[] 	= implode( ' OR ', $wheres2 );
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}
	
// Add Discussions Privacy
$pDiscussions = '';
if($opDiscussions)
	$pDiscussions = "AND p.permissions = 0";
	
// Show pictures
$picture = '';
if($showPictures)
	$picture = 'c.thumb as image, ';

	$query	= 'SELECT p.id, p.groupid, p.created AS created, p.title AS title, p.message as text, d.comment AS text, c.name as category, ' . $picture
			. ' CONCAT_WS("/", "'.JText::_( 'Discussions' ).'", c.name) AS section'
			. ' FROM ' . $db->nameQuote('#__community_groups_discuss') . ' AS p'
			. ' INNER JOIN ' . $db->nameQuote('#__community_groups') . ' AS c ON c.id = p.groupid'
			. ' LEFT JOIN ' . $db->nameQuote('#__community_wall') . ' AS d ON d.contentid = p.id AND d.type LIKE "discussions" '
			. ' WHERE ' . $where
			. ' GROUP BY p.id'
			. ' ORDER BY ' . $order;

	$db->setQuery( $query, 0, $limit );

	$rows = $db->loadObjectList();

	$comunityLib	= JPATH_ROOT . DS . 'components' . DS . 'com_community' . DS . 'libraries' . DS . 'core.php';

	include_once($comunityLib);

	foreach($rows as $key => $row) {
		$rows[$key]->href		= CRoute::_('index.php?option=com_community&view=groups&task=viewdiscussion&groupid='.$row->groupid.'&topicid='.$row->id);
		$rows[$key]->browsernav	= 2;
	}

	return $rows;
}

// todo Privacy
function plgCommunitySearchGroups( $text, $phrase='', $ordering='', $areas=null, $limit, $opGroups, $showPictures)
{
	$db		=& JFactory::getDBO();
	$user	=& JFactory::getUser();
	
	$searchText = $text;

	$text = trim( $text );
	if ( $text == '' ) {
		return array();
	}

	switch ( $ordering ) {
		case 'alpha':
			$order = 'a.`name` ASC';
			break;

		case 'category':
			$order = 'b.`name` ASC';
			break;
		case 'popular':
			$order = '`activities` DESC';
			break;		
		case 'newest':
		case 'oldest':
		default:
			$order = 'a.`name` DESC';
	}

	switch ($phrase)
	{
		case 'exact':
			$text		= $db->Quote( '%'.$db->getEscaped( $text, true ).'%', false );
			$wheres2 	= array();			
			$wheres2[] 	= 'a.description LIKE '.$text;
			$wheres2[] 	= 'a.name LIKE '.$text;
			$where 		= '(' . implode( ') OR (', $wheres2 ) . ')';
			break;

		case 'all':
		case 'any':
		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$word		= $db->Quote( '%'.$db->getEscaped( $word, true ).'%', false );
				$wheres2 	= array();
				$wheres2[] 	= 'a.description LIKE '.$word;
				$wheres2[] 	= 'a.name LIKE '.$word;
				
				$wheres[] 	= implode( ' OR ', $wheres2 );
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}
	
// Add Groups Privacy
$pGroups = '';
if($opGroups)
	$pGroups = "AND p.permissions = 0";
	
// Show pictures
$picture = '';
if($showPictures)
	$picture = 'a.thumb AS image, ';

	$query = 'SELECT a.`id`, a.`name` AS title, a.`description` AS text, b.`name` as category, ' . $picture;
	$query .= ' CONCAT_WS("/", "'.JText::_( 'Groups' ).'", b.name) AS section,';	
	$query .= ' "" AS created, COUNT(c.`cid`) AS `activities` ';
	$query .= ' FROM `#__community_groups` AS a';
	$query .= ' INNER JOIN `#__community_groups_category` AS b ON a.`categoryid` = b.`id`';
	$query .= ' LEFT JOIN `#__community_activities` AS c ON a.`id` = c.`cid`';
	$query .= ' WHERE ' . $where;
	$query .= ' AND a.`published` = 1';
	$query .= ' AND c.`app` = '. $db->quote('groups');
	$query .= ' AND c.`cid` != 0';
	$query .= ' GROUP BY c.`cid`';
	$query .= ' ORDER BY '. $order;
		
	$db->setQuery( $query, 0, $limit );
	$rows = $db->loadObjectList();
	
	include_once(JPATH_ROOT . DS . 'components' . DS . 'com_community' . DS . 'libraries' . DS . 'core.php');

	for($i=0; $i < count($rows); $i++)
	{
		$row	=& $rows[$i];
		$row->href			= CRoute::_('index.php?option=com_community&view=groups&task=viewgroup&groupid='.$row->id);
		$row->browsernav	= 2;
	}

	return $rows;
}

function plgCommunitySearchPhotos( $text, $phrase='', $ordering='', $areas=null, $limit, $opPhotos, $showPictures)
{
	$db		=& JFactory::getDBO();
	$user	=& JFactory::getUser();
	
	switch ( $ordering )
	{
		case 'alpha':
			$order = 'p.caption ASC';
			break;
		case 'category':
			$order = 'c.name ASC';
			break;
		case 'newest':
			$order = 'p.created DESC';
			break;
		case 'oldest':
			$order = 'p.created ASC';
			break;
		default:
			$order = 'p.caption DESC';
			break;
	}

	$text = trim( $text );
	if ($text == '') {
		return array();
	}

	switch ($phrase)
	{
		case 'exact':
			$text		= $db->Quote( '%'.$db->getEscaped( $text, true ).'%', false );
			$wheres2 	= array();
			$wheres2[] 	= 'p.caption LIKE '.$text;
			$wheres2[] 	= 'd.comment LIKE '.$text;
			$where 		= '(' . implode( ') OR (', $wheres2 ) . ')';
			break;

		case 'all':
		case 'any':
		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$word		= $db->Quote( '%'.$db->getEscaped( $word, true ).'%', false );
				$wheres2 	= array();
				$wheres2[] 	= 'p.caption LIKE '.$word;
				$wheres2[] 	= 'd.comment LIKE '.$word;
				$wheres[] 	= implode( ' OR ', $wheres2 );
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}

// Add Photos Privacy
$pPhotos = '';
if($opPhotos)
	$pPhotos = "AND p.permissions = 0";
	
// Show pictures
$picture = '';
if($showPictures)
	$picture = 'p.thumbnail AS image, ';
	
	$query	= 'SELECT p.id, c.groupid, p.albumid, p.creator, p.created AS created, p.caption AS title, c.name as category, d.comment, ' . $picture
			. ' CONCAT_WS("/", "'.JText::_( 'Photos' ).'", c.name) AS section'
			. ' FROM ' . $db->nameQuote('#__community_photos') . ' AS p'
			. ' INNER JOIN ' . $db->nameQuote('#__community_photos_albums') . ' AS c ON c.id = p.albumid'
			. ' LEFT JOIN ' . $db->nameQuote('#__community_wall') . ' AS d ON d.contentid = p.id AND d.type LIKE "photos"'
			. ' WHERE ' . $where
			. $pPhotos
			. ' GROUP BY p.id'
			. ' ORDER BY ' . $order;
	$db->setQuery( $query, 0, $limit );
	$rows = $db->loadObjectList();

	$comunityLib	= JPATH_ROOT . DS . 'components' . DS . 'com_community' . DS . 'libraries' . DS . 'core.php';
	include_once($comunityLib);

	foreach($rows as $key => $row) {
		
		if ($row->groupid == 0) {
		
		$rows[$key]->href		= CRoute::_('index.php?option=com_community&view=photos&task=photo&albumid='.$row->albumid.'&userid='.$row->creator.'#photoid='.$row->id);
		$rows[$key]->browsernav	= 2;
		}
		else {
		$rows[$key]->href		= CRoute::_('index.php?option=com_community&view=photos&task=photo&albumid='.$row->albumid.'&groupid='.$row->groupid.'#photoid='.$row->id);
		$rows[$key]->browsernav	= 2;
		}
	}

	return $rows;
}

function plgCommunitySearchVideos( $text, $phrase='', $ordering='', $areas=null, $limit, $opVideos, $showPictures)
{
	$db		=& JFactory::getDBO();
	$user	=& JFactory::getUser();

	// load plugin params info
 	// $plugin			=& JPluginHelper::getPlugin('search', 'videos');
 	// $pluginParams	= new JParameter( $plugin->params );

	switch ( $ordering )
	{
		case 'alpha':
			$order = 'v.title ASC';
			break;
		case 'category':
			$order = 'c.name ASC';
			break;
		case 'popular':
			$order = 'v.hits DESC';
			break;
		case 'newest':
			$order = 'v.created DESC';
			break;
		case 'oldest':
			$order = 'v.created ASC';
			break;
		default:
			$order = 'v.title DESC';
			break;
	}

	$text = trim( $text );
	if ($text == '') {
		return array();
	}

	switch ($phrase)
	{
		case 'exact':
			$text		= $db->Quote( '%'.$db->getEscaped( $text, true ).'%', false );
			$wheres2 	= array();
			$wheres2[] 	= 'v.title LIKE '.$text;
			$wheres2[] 	= 'v.description LIKE '.$text;
			$wheres2[] 	= 'd.comment LIKE '.$text;
			$where 		= '(' . implode( ') OR (', $wheres2 ) . ')';
			break;

		case 'all':
		case 'any':
		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$word		= $db->Quote( '%'.$db->getEscaped( $word, true ).'%', false );
				$wheres2 	= array();
				$wheres2[] 	= 'v.title LIKE '.$word;
				$wheres2[] 	= 'v.description LIKE '.$word;
				$wheres2[] 	= 'd.comment LIKE '.$word;
				$wheres[] 	= implode( ' OR ', $wheres2 );
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}

// Add Videos Privacy
$pVideos = '';
if($opVideos)
	$pVideos = "AND v.permissions = 0";
	
// Show pictures
$picture = '';
if($showPictures)
	$picture = 'v.thumb AS image, ';
	
	$query	= 'SELECT v.id, v.creator, v.groupid, v.creator_type, v.title AS title, v.description AS text, c.name as category, d.comment, ' . $picture
			. ' CONCAT_WS("/", "'.JText::_( 'Videos' ).'", c.name) AS section, "" AS created'
			. ' FROM ' . $db->nameQuote('#__community_videos') . ' AS v'
			. ' INNER JOIN ' . $db->nameQuote('#__community_videos_category') . ' AS c ON c.id = v.category_id'
			. ' LEFT JOIN ' . $db->nameQuote('#__community_wall') . ' AS d ON d.contentid = v.id AND d.type LIKE "videos"'
			. ' WHERE ' . $where
			. $pVideos
			. ' AND v.status = ' . $db->quote('ready')
			. ' GROUP BY v.id'
			. ' ORDER BY ' . $order;
	$db->setQuery( $query, 0, $limit );
	$rows = $db->loadObjectList();

	$comunityLib	= JPATH_ROOT . DS . 'components' . DS . 'com_community' . DS . 'libraries' . DS . 'core.php';
	include_once($comunityLib);

	foreach($rows as $key => $row) {
	
		if ($row->creator_type == "user") {
		$rows[$key]->href		= CRoute::_('index.php?option=com_community&view=videos&task=video&userid='.$row->creator.'&videoid='.$row->id);
		$rows[$key]->browsernav	= 2;
		}
		else {
		$rows[$key]->href		= CRoute::_('index.php?option=com_community&view=videos&task=video&groupid='.$row->groupid.'&videoid='.$row->id);
		$rows[$key]->browsernav	= 2;		
		}
	}

	return $rows;
}

function plgCommunitySearchEvents( $text, $phrase='', $ordering='', $areas=null, $limit, $opEvents, $showPictures)
{
	$db		=& JFactory::getDBO();
	$user	=& JFactory::getUser();

 	// $plugin			=& JPluginHelper::getPlugin('search', 'events');
 	// $pluginParams	= new JParameter( $plugin->params );

	switch ( $ordering )
	{
		case 'alpha':
			$order = 'e.title ASC';
			break;
		case 'category':
			$order = 'c.name ASC';
			break;
		case 'newest':
			$order = 'e.created DESC';
			break;
		case 'oldest':
			$order = 'e.created ASC';
			break;
		default:
			$order = 'e.title DESC';
			break;
	}

	$text = trim( $text );
	if ($text == '') {
		return array();
	}

	switch ($phrase)
	{
		case 'exact':
			$text		= $db->Quote( '%'.$db->getEscaped( $text, true ).'%', false );
			$wheres2 	= array();
			$wheres2[] 	= 'e.title LIKE '.$text;
			$wheres2[] 	= 'e.description LIKE '.$text;
			$wheres2[] 	= 'e.location LIKE '.$text;
			$wheres2[] 	= 'd.comment LIKE '.$text;
			$where 		= '(' . implode( ') OR (', $wheres2 ) . ')';
			break;

		case 'all':
		case 'any':
		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$word		= $db->Quote( '%'.$db->getEscaped( $word, true ).'%', false );
				$wheres2 	= array();
				$wheres2[] 	= 'e.title LIKE '.$word;
				$wheres2[] 	= 'e.description LIKE '.$word;
				$wheres2[] 	= 'e.location LIKE '.$word;
				$wheres2[] 	= 'd.comment LIKE '.$word;
				$wheres[] 	= implode( ' OR ', $wheres2 );
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}

// Add Events Privacy
$pEvents = '';
if($opEvents)
	$pEvents = "AND e.permission = 0";
	
// Show pictures
$picture = '';
if($showPictures)
	$picture = 'e.thumb AS image, ';
	
	$query	= 'SELECT c.id, e.id, e.type, e.catid, e.creator, e.created AS created, e.title AS title, e.description AS text, e.location, c.name as category, d.comment, ' . $picture
			. ' CONCAT_WS("/", "'.JText::_( 'Events' ).'", c.name) AS section'
			. ' FROM ' . $db->nameQuote('#__community_events') . ' AS e'
			. ' INNER JOIN ' . $db->nameQuote('#__community_events_category') . ' AS c ON c.id = e.catid'
			. ' LEFT JOIN ' . $db->nameQuote('#__community_wall') . ' AS d ON d.contentid = e.id AND d.type LIKE "events"'
			. ' WHERE ' . $where
			. $pEvents
			. ' GROUP BY e.id'
			. ' ORDER BY ' . $order;
	$db->setQuery( $query, 0, $limit );
	$rows = $db->loadObjectList();

	$comunityLib	= JPATH_ROOT . DS . 'components' . DS . 'com_community' . DS . 'libraries' . DS . 'core.php';
	include_once($comunityLib);

	foreach($rows as $key => $row)
	{
		$rows[$key]->href		= CRoute::_('index.php?option=com_community&view=events&task=viewevent&eventid='.$row->id);
		$rows[$key]->browsernav	= 2;
	}

	return $rows;
}
?>