var JoSticky = {};
dojo.require("dojo.window");

dojo.declare("JoSticky", null, {

	constructor: function(args) {
	 dojo.mixin(this,args);
	 this.init();
	},
	
	init: function(){
	  this.parent = this.node.parentNode;
    dojo.style(this.parent, 'position', 'relative');
    dojo.style(this.node, 'position', 'absolute');
    dojo.style(this.node, 'width', '100%');
    this.height = this.recursiveParentHeight(this.parent);
    this.onResize();
    
    dojo.connect(window, "scroll", dojo.hitch(this,'onScroll'));
    dojo.connect(window, "resize", dojo.hitch(this,'onResize'));
    dojo.connect(this.node, "click", dojo.hitch(this,'onNodeResize')); //Maybe the node resized/clicked
  },
  
  onScroll: function(){
    var parentPos = dojo.position(this.parent);
    var newPos = parentPos.y * -1 + 10;
    if(newPos < 0){
      newPos = 0;
    }else{
      this.nodeH = dojo.position(this.node).h;
      if(this.nodeH+newPos > this.height){
        newPos = this.height-this.nodeH;
      }
      if(this.nodeH > this.screenH){
        if(this.lastPos <= newPos) return;
      }
    }
    if(this.animtop && this.animtop.status() == "playing"){
        this.animtop.stop();
    }
    this.lastPos = newPos;
    this.animtop = dojo.animateProperty({node: this.node, properties: {top: newPos}, duration: 1000}).play();
  },
  
  onResize: function(){
	  this.screenH = dojo.window.getBox().h;
	  this.onScroll();
  },
  
  onNodeResize: function(e){
    if(this.nodeH != dojo.position(this.node).h){
      this.onScroll();
      setTimeout(dojo.hitch(this,'onNodeResize'), 500);
    }
    if(typeof(e) == 'object'){
      setTimeout(dojo.hitch(this,'onNodeResize'), 500);
      return;
    }
  },
  
  recursiveParentHeight: function(node){
    var h = dojo.position(node).h;
    if(h > this.minheight) return h;
    return this.recursiveParentHeight(node.parentNode);
  } 
  
});