<?php
/*-------------------------------------------------------------------------
# mod_fancy_tagcloud - Fancy TagCloud
# -------------------------------------------------------------------------
# @ author    Jeno Kovacs
# @ copyright Copyright (C) 2016 Offlajn.com  All Rights Reserved.
# @ license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# @ website   http://www.offlajn.com
-------------------------------------------------------------------------*/
?><?php
// no direct access
defined('_JEXEC') or die('Restricted access');


if(!defined('OfflajnJoomlaTags')) {
  define("OfflajnJoomlaTags", null);

  require_once(dirname(__FILE__). '/../../core/TagBase.php');
  JLoader::register('TagsHelperRoute', JPATH_BASE . '/components/com_tags/helpers/route.php');

  class OfflajnJoomlaTags extends OfflajnTagBase{

    function OfflajnJoomlaTags($module, $params){
      parent::OfflajnTagBase($module, $params);
    }

    function getElements()  {
      $type = $this->_params->get('joomlacategoryid');
      $limit = $this->_params->get('limit', 10);
      $db =& JFactory::getDBO();

      $categoryid = "";
      $where = "";
      $order = "";
      $items = "";

                $cache = & JFactory::getCache();
                $cache->setCaching( $this->_params->get('caching', 0) );
                if($type) {
                  $this->pcatid = $type;
                  $items = $cache->call(array( $this, 'getCategories' ));
                  $categories = implode(",", $items);
                  $where = " AND a.catid IN (".$categories.") ";
                }

        $app = JFactory::getApplication();
		    $user = JFactory::getUser();
		    $groups = implode(',', $user->getAuthorisedViewLevels());
		    $tag = JFactory::getLanguage()->getTag();
       	$nullDate = $db->getNullDate();
		    $date = JFactory::getDate();
		    $now = $date->toSql();

        $query = "
          SELECT a.id, a.title
				    FROM #__content AS a
				    LEFT JOIN #__categories AS c ON c.id=a.catid
				    WHERE a.state=1 AND c.published = 1 AND a.access IN (" . $groups . ") AND c.access IN (" . $groups . ")
						  AND (a.publish_up = " . $db->quote($nullDate) . " OR a.publish_up <= " . $db->quote($now) . ")
						  AND (a.publish_down = " . $db->quote($nullDate) . " OR a.publish_down >= " . $db->quote($now) . ")";

        if ($app->isSite() && JLanguageMultilang::isEnabled()) {
				  $where .= " AND a.language in (" . $db->quote($tag) . "," . $db->quote('*') . ") ";
				  $where .= " AND c.language in (" . $db->quote($tag) . "," . $db->quote('*') . ") ";
			  }

        $query .= $where. " GROUP BY a.id ".$order;


        $db->setQuery($query);
        $items = $db->loadColumn();
        $items = implode(",", $items);

        $query = "SELECT DISTINCT t.id AS id, t.alias AS alias, t.title AS name, (SELECT COUNT(*) FROM #__tags As tc LEFT JOIN #__contentitem_tag_map AS tm ON  tc.id = tm.tag_id WHERE tc.id = t.id) AS count
            FROM #__tags AS t
            LEFT JOIN #__contentitem_tag_map AS tm ON t.id=tm.tag_id
            WHERE tm.content_item_id IN (".$items.") GROUP BY t.id";
        $query .= " LIMIT 0,".$limit;
      $db->setQuery($query);
      $rows = $db->loadObjectList();
      return $rows;
    }


    function createItem($item) {
      $element = new stdClass();
			$element->tag = $item->name;
			$element->count = $item->count;
      $element->link = JRoute::_(TagsHelperRoute::getTagRoute($item->id . ':' . $item->alias));
      return $element;
    }


    function getCategories() {
      $categoryid = explode("|", $this->pcatid);
      $db =& JFactory::getDBO();
      $query = "SELECT DISTINCT id AS id,";

      if(!is_array($categoryid) && $categoryid != 0){
        $query.="IF(parent_id = ".$categoryid.", 0 , IF(parent_id = 0, -1, parent_id)) AS parent ";
      }elseif(count($categoryid) && is_array($categoryid) && !in_array('0', $categoryid)){
        $query.="IF(id in (".implode(',', $categoryid)."), 0 , IF(parent_id = 0, -1, parent_id)) AS parent ";
      }else{
        $query.="parent_id AS parent ";
      }
      $query.= " FROM #__categories
                WHERE published =1 AND extension='com_content'";


      $db->setQuery($query);
      $this->allItems = $db->loadObjectList('id');
      $this->filterItems();
      $p = new stdClass();
      $p->id = 0;
      $items = $this->getChilds($p, 1);
      return $this->ids;
    }
  }
}
?>