<?php
/*-------------------------------------------------------------------------
# mod_fancy_tagcloud - Fancy TagCloud
# -------------------------------------------------------------------------
# @ author    Jeno Kovacs
# @ copyright Copyright (C) 2014 Offlajn.com  All Rights Reserved.
# @ license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# @ website   http://www.offlajn.com
-------------------------------------------------------------------------*/
?><?php
// no direct access
defined('_JEXEC') or die('Restricted access');


if(!defined('OfflajnK2Tags')) {
  define("OfflajnK2Tags", null);

  require_once (JPATH_SITE.'/components/com_k2/helpers/route.php');
  require_once (JPATH_SITE.'/components/com_k2/helpers/utilities.php');
  //require_once (dirname(__FILE__).'/includes/calendarClass.php');

  require_once(dirname(__FILE__).'/../../core/TagBase.php');

  class OfflajnK2Tags extends OfflajnTagBase{

    function OfflajnK2Tags($module, $params){
      parent::OfflajnTagBase($module, $params);
    }

    function getElements()  {
  		$mainframe = JFactory::getApplication();
  		$user = JFactory::getUser();
  		$aid = (int)$user->get('aid');
  		$db = JFactory::getDBO();

  		$jnow = JFactory::getDate();
  		$now = K2_JVERSION == '15' ? $jnow->toMySQL() : $jnow->toSql();

  		$nullDate = $db->getNullDate();

  		$query = "SELECT i.id, i.title FROM #__k2_items as i";
  		$query .= " LEFT JOIN #__k2_categories c ON c.id = i.catid";
  		$query .= " WHERE i.published=1 ";
  		$query .= " AND ( i.publish_up = ".$db->Quote($nullDate)." OR i.publish_up <= ".$db->Quote($now)." ) ";
  		$query .= " AND ( i.publish_down = ".$db->Quote($nullDate)." OR i.publish_down >= ".$db->Quote($now)." )";
  		$query .= " AND i.trash=0 ";
  		if (K2_JVERSION != '15')
  		{
  			$query .= " AND i.access IN(".implode(',', $user->getAuthorisedViewLevels()).") ";
  		}
  		else
  		{
  			$query .= " AND i.access <= {$aid} ";
  		}
  		$query .= " AND c.published=1 ";
  		$query .= " AND c.trash=0 ";
  		if (K2_JVERSION != '15')
  		{
  			$query .= " AND c.access IN(".implode(',', $user->getAuthorisedViewLevels()).") ";
  		}
  		else
  		{
  			$query .= " AND c.access <= {$aid} ";
  		}

      $type = $this->_params->get('k2categories');
      $where = "";
      $cache = & JFactory::getCache();
      $cache->setCaching( $this->_params->get('caching', 0) );

      if($type) {
        $this->pcatid = $type;
        $items = $cache->call(array( $this, 'getCategories' ));
        $categories = implode(",", $items);
        $where = " AND i.catid IN (".$categories.") ";
      }

  				$query .= $where." ";


  		if (K2_JVERSION != '15')
  		{
  			if ($mainframe->getLanguageFilter())
  			{
  				$languageTag = JFactory::getLanguage()->getTag();
  				$query .= " AND c.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") AND i.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") ";
  			}
  		}

  		$db->setQuery($query);
  		$IDs = K2_JVERSION == '30' ? $db->loadColumn() : $db->loadResultArray();



  		if (!is_array($IDs) || !count($IDs))
  		{
  			return array();
  		}

    		$query = "SELECT tag.id AS id, tag.name AS name,
        (SELECT COUNT(*) FROM #__k2_tags As tc LEFT JOIN #__k2_tags_xref AS tm ON  tc.id = tm.tagID WHERE tc.id = tag.id) AS count
          FROM #__k2_tags as tag
          LEFT JOIN #__k2_tags_xref AS xref ON xref.tagID = tag.id
          WHERE xref.itemID IN (".implode(',', $IDs).")
          AND tag.published = 1 GROUP BY tag.id";

      $db->setQuery($query);

  		$rows = $db->loadObjectList();

      return $rows;
    }


    function createItem($item) {
      $element = new stdClass();
			$element->tag = $item->name;
			$element->count = $item->count;
			$element->link = urldecode(JRoute::_(K2HelperRoute::getTagRoute($item->name)));
      return $element;
    }


    function getCategories() {
      $categoryid = explode("|", $this->pcatid);
      $db =& JFactory::getDBO();
      $query = "SELECT DISTINCT id AS id,";

      if(!is_array($categoryid) && $categoryid != 0){
        $query.="IF(parent = ".$categoryid.", 0 , IF(parent = 0, -1, parent)) AS parent ";
      }elseif(count($categoryid) && is_array($categoryid) && !in_array('0', $categoryid)){
        $query.="IF(id in (".implode(',', $categoryid)."), 0 , IF(parent = 0, -1, parent)) AS parent ";
      }else{
        $query.="parent AS parent ";
      }
      $query.= " FROM #__k2_categories
                WHERE published=1 ";




      $db->setQuery($query);
      $this->allItems =  $db->loadObjectList('id');
      $this->filterItems();
      $p = new stdClass();
      $p->id = 0;
      $items = $this->getChilds($p, 1);
      return $this->ids;
    }
  }
}
?>