<?php
/*-------------------------------------------------------------------------
# mod_fancy_tagcloud - Fancy TagCloud
# -------------------------------------------------------------------------
# @ author    Jeno Kovacs
# @ copyright Copyright (C) 2016 Offlajn.com  All Rights Reserved.
# @ license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# @ website   http://www.offlajn.com
-------------------------------------------------------------------------*/
?><?php
// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' ); 
 
if(!defined('OfflajnTagBase')) {
  define("OfflajnTagBase", null);
  
  //require_once( dirname(__FILE__).'/imageCache.php' );

  class OfflajnTagBase{
  
    var $mode;
    
    var $_module;
    
    var $_params;
    
    var $_template;
    
    var $items;
    
    var $rendered;
    
    function OfflajnTagBase($module, $params){
      $this->_module = $module;
      $this->_params = $params;
      $this->endLevel = 1000;
      $this->startLevel = 0;
      $this->ids = array();
      //$this->imageCache = new OfflajnUniversalImageCaching();
    }
    
    function getItems() {
      $this->items = $this->getElements();
      $this->render();
      return count($this->items);
    }
    
    function render(){
      $this->pointer = 0;
  	  $this->itemsCount = count($this->items); 
      return $this->renderItems();
    }
    
    function getImage($image) {
      return $image;
    }

    
    function renderItems() {
      //$tempArr = array();
      $elements = array();
      while($this->pointer < $this->itemsCount){
        $item =& $this->items[$this->pointer++];
        //$elements .= '<div class="off-uni-slider-item"><img class="off-uni-slider-img" src="'.$item->image.'"/><span class="item_name">'.$item->name.'</span></div>';
        $elements[] = $this->createItem($item);
      }
          //print_r($elements); exit;
      return $elements;
    } 
    
    function filterItems(){
  		$this->helper = array();
  		foreach ($this->allItems as $item){
  			if (!is_object($item)) continue;
  			  $item->p = false; // parent
  			  $item->fib = false; // First in Branch
  			  $item->lib = false; // Last in Branch
 
  				$this->helper[$item->parent][] = $item;
  		}
    }
    
    function getChilds(&$parent, $level){
  	  $items = array();
  	  if(isset($this->helper[$parent->id])){
        $helper = &$this->helper[$parent->id];
        //usort($helper, array($this, "menuOrdering")); // It can slow down the proccess. Not required every time... With this the process half as fast...
        $helper[0]->fib = true;
        $helper[count($helper)-1]->lib = true;
        if($level <= $this->endLevel){
          $i = 0;
          $keys = array_keys($helper);
          for($j = 0; $j < count($keys); $j++){
            $h = &$helper[$keys[$j]];
            $h->parent = &$parent;
            $childs =& $this->getChilds($h, $level+1);
            if(count($childs) > 0) $h->p = true;
            $h->level = $level;
            $items[] = &$h;
            $this->ids[] = $h->id;
            $i = count($items);
            array_splice($items, $i, 0, $childs);
          }
        }
      }
      return $items;
    }    
  }
}
?>