<?php
/*-------------------------------------------------------------------------
# mod_fancy_tagcloud - Fancy TagCloud
# -------------------------------------------------------------------------
# @ author    Jeno Kovacs
# @ copyright Copyright (C) 2016 Offlajn.com  All Rights Reserved.
# @ license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# @ website   http://www.offlajn.com
-------------------------------------------------------------------------*/
?><?php
defined('_JEXEC') or die('Restricted access');

if(!class_exists('JElementOfflajnList')) {
  require_once( (dirname(__FILE__)) . '/../offlajnlist/offlajnlist.php');
}

class JElementOfflajnGoogleFonts extends JElementOfflajnList {

	var	$_name = 'OfflajnGoogleFonts';

	function universalfetchElement($name, $value, &$node){
    $attrs = $node->attributes();
    $this->loadFiles();

    $this->_google = array();
    $this->_googleName = array();
    $this->_googlefonts = array();
    $this->init();

    $listnode = new JSimpleXMLElement('list');
    $datas = array();
    $t = $attrs["fonttype"];

    foreach($this->_googlefonts[$t] AS $f){
        if(strlen($f) > 0)
          $listnode->addChild('option', array('value'=>$f))->setData($f);
    }

    preg_match('/(.*)\[([a-zA-Z0-9]*)\]$/', $name, $out);
    $html = parent::universalfetchElement($name, $value, $listnode);

    return $html;
	}

  function init(){
	  $p = dirname(__FILE__).'/google/';
    $google = JFolder::files($p, '.txt');
    foreach($google as $g){
      $this->_google[] = JFile::stripExt($g);
      preg_match_all('/((?:^|[A-Z])[a-z]+)/',JFile::stripExt($g),$matches);
      $this->_googleName[] = implode(' ', $matches[1]);
      $fp = @fopen($p.$g, 'r');
      if ($fp) {
        $this->_googlefonts[JFile::stripExt($g)] = explode("\r\n", fread($fp, filesize($p.$g)));
      }
      fclose($fp);
    }
  }
}

if(version_compare(JVERSION,'1.6.0','ge')) {
  class JFormFieldOfflajnGoogleFonts extends JElementOfflajnGoogleFonts {}
}