<?php
/*-------------------------------------------------------------------------
# mod_fancy_tagcloud - Fancy TagCloud
# -------------------------------------------------------------------------
# @ author    Jeno Kovacs
# @ copyright Copyright (C) 2016 Offlajn.com  All Rights Reserved.
# @ license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# @ website   http://www.offlajn.com
-------------------------------------------------------------------------*/
$revision = '1.021';
?><?php
// Report all PHP errors (see changelog)
defined('_JEXEC') or die('Restricted access');

global $ImageHelper, $bgHelper;


require_once(dirname(__FILE__).'/helpers/functions.php');

$module->navClassPrefix = 'off-scr-';
$module->instanceid = 'offlajn-tagcloud-'.$module->id.'-1';
$module->containerinstanceid = $module->instanceid.'-container';
$document = JFactory::getDocument();

if(version_compare(JVERSION,'1.6.0','ge')) {
  if ($params->get('moduleclass_sfx', '') != @$params->get('otherTab')->moduleclass_sfx) {
    $params->set('moduleclass_sfx', $params->get('otherTab')->moduleclass_sfx);
    $db =& JFactory::getDBO();
    $db->setQuery('UPDATE #__modules SET params=\''.addslashes($params->toString()).'\' WHERE id='.$module->id);
    $db->query();
  }
  $params->loadArray(o_flat_array($params->toArray()));
}

$type = preg_replace("/[^A-Za-z0-9]/", '', $params->get('menutype'));
if($type == '' or !file_exists(dirname(__FILE__).'/types/'.$type.'/tags.php')){
  echo JText::_('TagCloud type not exists!');
  return;
}

require_once(dirname(__FILE__).'/types/'.$type.'/tags.php');

$class = 'Offlajn'.ucfirst($type).'Tags';
if(!class_exists($class)) return;
$slider = new $class($module, $params);
$itemsCount = $slider->getItems();


/*
Loading the template file for the theme
*/
$templateDir = dirname(__FILE__).'/template/';

$theme = $params->get('theme', 'default');
$tmpl = $templateDir.$theme.'.php';

if(!file_exists($tmpl)){
  $tmpl = $templateDir.'default.php';
  if(!file_exists($tmpl)){
    echo JText::_('Template file missing for Offlajn TagCloud. Please reinstall the module.');
    return;
  }
}

$containerTmpl = $templateDir.$theme.'.php';


if(!file_exists($containerTmpl)){
  $containerTmpl = $templateDir.'default-cont.php';
  if(!file_exists($containerTmpl)){
    echo JText::_('Template file missing for Offlajn TagCloud. Please reinstall the module.');
    return;
  }
}

include($containerTmpl);

require_once(dirname(__FILE__).'/classes/cache.class.php');
$cache = new OfflajnMenuThemeCache('simple', $module, $params);

$root = JURI::root(true);
if ($root != '/') $root.= '/';

if (version_compare(JVERSION, '3.0.0', 'l')) {
  if ($params->get('jquery', 1)) {
    $document->addScript('https://ajax.googleapis.com/ajax/libs/jquery/1.8/jquery.min.js');
    $document->addScript($root.'media/offlajn/jquery.noconflict.js');
  }
} else JHtml::_('jquery.framework');

/*
Build the CSS
*/
$cache->addCss(dirname(__FILE__).'/themes/clear.css.php');
$cache->addCss(dirname(__FILE__).'/themes/'.$theme.'/theme.css.php');

$cache->assetsAdded();

/*
Set up enviroment variables for the cache generation
*/
$module->url = JUri::root(true).'/modules/'.$module->module.'/';
$cache->addCssEnvVars('module', $module);

$ImageHelper = new OfflajnImageHelper($cache->cachePath, $cache->cacheUrl);
$bgHelper = new OfflajnBgHelper($cache->cachePath, $cache->cacheUrl);

/*
Add cached contents to the document
*/
$cacheFiles = $cache->generateCache();

  $document->addStyleSheet($cacheFiles[0]);
  $document->addScript($module->url."/js/jquery.awesomeCloud-0.2.min.js");
  $font = OfflajnValueParser::parse($params->get('googlefont'));
  $color = explode("-", $params->get('gradient'));
  $grid = $params->get('grid', '5');
  $factor = ( (float)$params->get('factor', '0.1') > 0 && (float)$params->get('factor', '0.1') < 1) ? (float)$params->get('factor', '0.1') : '0';

 $document->addScriptDeclaration('
  ;(window.jq183||jQuery)(document).ready(function($) {
    var cont = "'.$module->instanceid.'-container-inner";
  	$("." + cont).awesomeCloud({
  		"size" : {
  			"grid" : '.$grid.',
        "factor" : '.$factor.'
  		},
      "color": {
        background: "transparent",
        "start" : "#'.$color[1].'",
        "end" : "#'.$color[2].'"
      },
  		"options" : {
  			"rotationRatio" : 0.35,
  			"sort" : "random"
  		},
  		"font" : "\''.$font[0].'\', sans-serif",
  		"shape" : "square"
  	});
  });
 ');

?>